using System;
using System.Collections.Generic;
using System.Windows.Forms;
using System.IO;
using System.Threading;
using System.Diagnostics;
using System.Reflection;


namespace LFS_External_Client
{
	static class Program
	{
        static readonly string LogPath = Path.Combine(Application.StartupPath, "unhandledErrorLog.txt");

		/// <summary>
		/// The main entry point for the application.
		/// </summary>
        [STAThread]
        static void Main()
		{
#if !DEBUG
            AppDomain.CurrentDomain.UnhandledException +=
                new UnhandledExceptionEventHandler(CurrentDomain_UnhandledException);
            Application.ThreadException +=
                new ThreadExceptionEventHandler(Application_ThreadException);
#endif

			Application.EnableVisualStyles();
			Application.SetCompatibleTextRenderingDefault(false);
			Application.Run(new Form1());

            using (Form1 Form1 = new Form1())
            {
                Application.EnableVisualStyles();
                Application.SetCompatibleTextRenderingDefault(false);
                Application.Run(Form1);
            }

        }
        static void Application_ThreadException(object sender, ThreadExceptionEventArgs e)
        {
            ManageUnhandledException(e.Exception);
        }

        static void CurrentDomain_UnhandledException(object sender, UnhandledExceptionEventArgs e)
        {
            ManageUnhandledException((Exception)e.ExceptionObject);
        }

        static void ManageUnhandledException(Exception e)
        {
            try
            {
                using (StreamWriter writer = new StreamWriter(LogPath))
                {
                    writer.WriteLine("Name: " + Assembly.GetExecutingAssembly().GetName().Name);
                    writer.WriteLine("Version: " + Assembly.GetExecutingAssembly().GetName().Version.ToString());
                    writer.WriteLine("Date: " + DateTime.Now.ToString());
                    writer.WriteLine("OS: " + Environment.OSVersion.VersionString);
                    writer.WriteLine("Culture: " + Thread.CurrentThread.CurrentUICulture);
                    writer.WriteLine("Message: " + e.Message);
                    writer.WriteLine("Source: " + e.Source);
                    writer.WriteLine("Target: " + e.TargetSite);
                    writer.WriteLine("Stack Trace: " + e.StackTrace);
                    writer.WriteLine("Inner Exception: " + e.InnerException);
                }

                try
                {
                    Form1.InSim.Send_MST_Message("/msg ^8 ^1Unhandled exception data written in log file!");
                }
                catch { }
            }
            catch (Exception ex)
            {
                if (MessageBox.Show(ex.Message, "Critical Error!") == DialogResult.OK)
                {
                    Process.GetCurrentProcess().Kill();
                }
            }
        }
	}
}